﻿Shader "!FullControl/Effects/Refractive Advanced Pan UVs" {

Properties 
{
    _MainTex ("Distort Texture (RGB)", 2D) = "black" { }
	_RefrColor ("Refraction Color", Color) = (1,1,1,1)
	_RefrIntensity ("Refraction Intensity", float) = 1.5
	_RefrDist  ("Refraction Distortion", range (0,50)) = 50
	
	//Animation Properties
	
	_MainSpeed ("Main Speed", Float) = 1.0
	_PanR_X ("Pan R - X", Float) = 1.0
	_PanR_Y ("Pan R - Y", Float) = 1.0
	
	_PanG_X ("Pan G - X", Float) = 1.0
	_PanG_Y ("Pan G - Y", Float) = 1.0
	
	_PanB_X ("Pan B - X", Float) = 1.0
	_PanB_Y ("Pan B - Y", Float) = 1.0
}

SubShader 
{
   		Tags {"Queue"="Trasparent" "IgnoreProjector" = "True"}
		Blend SrcAlpha OneMinusSrcAlpha
		
		ZWrite Off Fog {Color (0,0,0,0)}
		
		GrabPass 
		{							
			Name "BASE"
			Tags { "LightMode" = "Always" "IgnoreProjector" = "True"}
 		}
		
   		Pass 
   		{
  			Name "BASE"
			Tags { "LightMode" = "Always" "IgnoreProjector" = "True"}
		
		CGPROGRAM
		#pragma exclude_renderers d3d11 xbox360
		#pragma vertex vert
		#pragma fragment frag
		#include "UnityCG.cginc"
		//#pragma multi_compile_particles
		

		uniform sampler2D _MainTex;
		uniform float4 _MainTex_ST;
		
		uniform	sampler2D _GrabTexture;
		uniform float4 _GrabTexture_TexelSize;
		uniform float4 _RefrColor;
		uniform float _RefrIntensity;
		uniform float _RefrDist;
	//	uniform sampler2D _BumpMap;

		struct v2f 
		{
			//float4 vertex : POSITION;
		    float4  pos : POSITION; //SV_POSITION
		    float2  uv : TEXCOORD0;
		    float2 uvmask : TEXCOORD2;
		    float4 	color : COLOR;
		    float4 uvgrab : TEXCOORD1;
		};
		
		v2f vert (appdata_full v) : COLOR
		{
		    v2f o;
		    #if UNITY_UV_STARTS_AT_TOP
			float scale = -1.0;
			#else
			float scale = 1.0;
			#endif
		    o.pos = mul (UNITY_MATRIX_MVP, v.vertex);
			o.uv = TRANSFORM_TEX (v.texcoord, _MainTex);
			o.uvmask = v.texcoord;
			o.color = v.color;
			
			o.uvgrab.xy = (float2(o.pos.x, o.pos.y * scale) + o.pos.w) * 0.5;
			o.uvgrab.zw = o.pos.zw;
			
		    return o;
		}
		
		//Animation
		float _MainSpeed;
		
		float _PanR_X;
		float _PanR_Y;
		
		float _PanG_X;
		float _PanG_Y;
		
		float _PanB_X;
		float _PanB_Y;

		
		half4 frag (v2f i) : COLOR
		{
			fixed2 panUVa = i.uv;
			fixed time = _Time * _MainSpeed;
			fixed panRuvX = _PanR_X * time;
			fixed panRuvY = _PanR_Y * time;
			
			fixed panGuvX = _PanG_X * time;
			fixed panGuvY = _PanG_Y * time;
			
			fixed panBuvX = _PanB_X * time;
			fixed panBuvY = _PanB_Y * time;
			
			panUVa += fixed2(panRuvX, panRuvY);

			fixed2 panUVb = i.uv;
			panUVb += fixed2(panGuvX, panGuvY);
			
			fixed2 panUVc = i.uv;
			panUVc += fixed2(panBuvX, panBuvY);
			
			fixed4 textR = tex2D (_MainTex, panUVa).r;
			fixed4 textG = tex2D (_MainTex, panUVb).g;
			fixed4 textB = tex2D (_MainTex, panUVc).b;
			
			fixed4 mask = tex2D (_MainTex, i.uvmask);
			
			fixed textRGB = textR * 0.5 + textG * 0.5 + textB * 0.5;
			
			float2 offset = textRGB * _RefrDist * _GrabTexture_TexelSize.xy * i.color.a;
			i.uvgrab.xy = offset * i.uvgrab.z + i.uvgrab.xy;	
			half4 refr = tex2Dproj(_GrabTexture, UNITY_PROJ_COORD(i.uvgrab));
			
			half4 finalRefr = refr * _RefrColor;
			finalRefr.a = mask.a  * i.color.a * _RefrIntensity;
			//finalRefr.a = mask.a;
			
			//return mask.a;
			return finalRefr;
			//return (finalColor + finalRefr) * mask;
		}
		
		ENDCG
	}
}
//Fallback "VertexLit"
} 
